# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 1999,2002 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package CT::MCerr;
# "@(#)77   1.5   src/rsct/rmc/ext/CT/MCerr/MCerr.pm, rmccli, rsct_rpyxh, rpyxht1f3 3/11/01 17:54:45"

use strict;
use Carp;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK $AUTOLOAD);

require Exporter;
require DynaLoader;
require AutoLoader;

@ISA = qw(Exporter DynaLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(
    RMC_EAACNOTDEFINED
    RMC_EACCESS
    RMC_EACTIONMISSING
    RMC_EALLQUANTUM
    RMC_EATTRMISSING
    RMC_EATTRNOTSD
    RMC_EAUTHENTICATE
    RMC_EAUTHORIZATION
    RMC_EBADACTIONNAM
    RMC_EBADATTRNAM
    RMC_EBADATTRTYPE
    RMC_EBADLOCATORVALUE
    RMC_EBADNAMECOUNT
    RMC_EBADREGID
    RMC_EBADRSRCHANDLE
    RMC_EBADSDUSEARG
    RMC_EBADVVUSEARG
    RMC_ECLASSNOTDEFINED
    RMC_ECMDNOTSUPPORTED
    RMC_EDATTRNOTSUPPORTED
    RMC_EDUPATTRNAM
    RMC_EENUMERROR
    RMC_EEVALUATIONERROR
    RMC_EEXPRDIFFATTRS
    RMC_EEXPRMISSING
    RMC_EEXPRNODATTRNAME
    RMC_EEXPRNOTFORQUANTUM
    RMC_EMAYNOTSETPATTRS
    RMC_EMISSINGCLASSNAME
    RMC_EMISSINGDATTRVALUES
    RMC_EMISSINGPATTRVALUES
    RMC_ENOACTIONSDINPUT
    RMC_ENOACTIONSDRESPONSE
    RMC_ENOATTRIBUTES
    RMC_ENOCDATTRSDEFINED
    RMC_ENOCPATTRSDEFINED
    RMC_ENODATTRSDEFINED
    RMC_ENODENOTAVAILABLE
    RMC_ENODEOUT
    RMC_ENODESCRIPTIONS
    RMC_ENOENUMRSP
    RMC_ENOLOCATORATTR
    RMC_ENOPATTRSDEFINED
    RMC_ENOQUERYQUANTUM
    RMC_ENOREGEVENT
    RMC_ENORSRCFORCMD
    RMC_ENORSRCSFOUND
    RMC_ENOSELECTDONE
    RMC_ENOVALOTHERERROR
    RMC_EOKBUTOTHERERROR
    RMC_ERAEXPRISNULL
    RMC_ERAEXPRNOTALLOWED
    RMC_ERMNOTAVAILABLE
    RMC_ERMTERMWITHNORSP
    RMC_ERMTERMWITHRSP
    RMC_ERSRCNOTDEFINED
    RMC_ERSRCSTALE
    RMC_ERSRCUNDEFINED
    RMC_ESDNOTDEFINED
    RMC_ESELSTRBADNEXPR
    RMC_ESELSTRBADNODNUM
    RMC_ESELSTRNOSELECT
    RMC_ESHAREDMEMORY
    RMC_ESUBSECURITY
    RMC_GENERR_CMD_SPEC
    RMC_GENERR_EXPR
    RMC_GENERR_RESOURCE
    RMC_GENERR_SECURITY
    RMC_GENERR_SELECT
);
$VERSION = '0.01';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "& not defined" if $constname eq 'constant';
    my $val = constant($constname, @_ ? $_[0] : 0);
    if ($! != 0) {
    if ($! =~ /Invalid/) {
        $AutoLoader::AUTOLOAD = $AUTOLOAD;
        goto &AutoLoader::AUTOLOAD;
    }
    else {
        croak "Your vendor has not defined CT::MCerr macro $constname";
    }
    }
    no strict 'refs';
    # *$AUTOLOAD = sub () { $val };
    $AUTOLOAD = sub () { $val };
    goto &$AUTOLOAD;
}

bootstrap CT::MCerr $VERSION;

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__


=head1 NAME

CT::MCerr - Perl extensions for RSCT RMC ct_mcerr.h 


=head1 SYNOPSIS

use CT::MCerr;


=head1 DESCRIPTION

This extension is used by the Reliable Scalable Cluster Technology
(RSCT) Resource Monitoring and Control (RMC) Commands.
RMC Commands are located in /usr/sbin/rsct/bin.
Some of the RMC Commands are:
lsrsrc, lsrsrcdef, mkrsrc, rmrsrc, chrsrc, refrsrc, lsactdef.
The MCerr extension contains all RMC daemon return codes.

The Perl to C Extensions for RSCT RMC,
CT::MCerr, are not being externalized at this time.
Use at your own risk!
The API to these extensions will probably change.

=head1 Exported constants

For more information regarding these exported constants see the file:
    /usr/include/rsct/ct_mcerr.h

    RMC_EAACNOTDEFINED
    RMC_EACCESS
    RMC_EACTIONMISSING
    RMC_EALLQUANTUM
    RMC_EATTRMISSING
    RMC_EATTRNOTSD
    RMC_EAUTHENTICATE
    RMC_EAUTHORIZATION
    RMC_EBADACTIONNAM
    RMC_EBADATTRNAM
    RMC_EBADATTRTYPE
    RMC_EBADLOCATORVALUE
    RMC_EBADNAMECOUNT
    RMC_EBADREGID
    RMC_EBADRSRCHANDLE
    RMC_EBADSDUSEARG
    RMC_EBADVVUSEARG
    RMC_ECLASSNOTDEFINED
    RMC_ECMDNOTSUPPORTED
    RMC_EDATTRNOTSUPPORTED
    RMC_EDUPATTRNAM
    RMC_EENUMERROR
    RMC_EEVALUATIONERROR
    RMC_EEXPRDIFFATTRS
    RMC_EEXPRMISSING
    RMC_EEXPRNODATTRNAME
    RMC_EEXPRNOTFORQUANTUM
    RMC_EMAYNOTSETPATTRS
    RMC_EMISSINGCLASSNAME
    RMC_EMISSINGDATTRVALUES
    RMC_EMISSINGPATTRVALUES
    RMC_ENOACTIONSDINPUT
    RMC_ENOACTIONSDRESPONSE
    RMC_ENOATTRIBUTES
    RMC_ENOCDATTRSDEFINED
    RMC_ENOCPATTRSDEFINED
    RMC_ENODATTRSDEFINED
    RMC_ENODENOTAVAILABLE
    RMC_ENODEOUT
    RMC_ENODESCRIPTIONS
    RMC_ENOENUMRSP
    RMC_ENOLOCATORATTR
    RMC_ENOPATTRSDEFINED
    RMC_ENOQUERYQUANTUM
    RMC_ENOREGEVENT
    RMC_ENORSRCFORCMD
    RMC_ENORSRCSFOUND
    RMC_ENOSELECTDONE
    RMC_ENOVALOTHERERROR
    RMC_EOKBUTOTHERERROR
    RMC_ERAEXPRISNULL
    RMC_ERAEXPRNOTALLOWED
    RMC_ERMNOTAVAILABLE
    RMC_ERMTERMWITHNORSP
    RMC_ERMTERMWITHRSP
    RMC_ERSRCNOTDEFINED
    RMC_ERSRCSTALE
    RMC_ERSRCUNDEFINED
    RMC_ESDNOTDEFINED
    RMC_ESELSTRBADNEXPR
    RMC_ESELSTRBADNODNUM
    RMC_ESELSTRNOSELECT
    RMC_ESHAREDMEMORY
    RMC_ESUBSECURITY
    RMC_GENERR_CMD_SPEC
    RMC_GENERR_EXPR
    RMC_GENERR_RESOURCE
    RMC_GENERR_SECURITY
    RMC_GENERR_SELECT


=head1 AUTHOR

Licensed Materials - Property of IBM
 
(C) COPYRIGHT International Business Machines Corp. 2000, 2001.
All Rights Reserved.
 
US Government Users Restricted Rights - Use, duplication or
disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 

=head1 VERSION

RSCT Version 2.2 


=head1 SEE ALSO

rmccli, CT::CT, CT::MC, CT::RM

=cut
